<?php

// Include the configuration file where constants are defined
include_once('engine_all_config_new.php');  // Ensure the correct path to your config file
include_once('engine_shopify_functions.php');  // Include your custom functions

// Expedited Shipping Methods (with flexible matching)
$expeditedMethods = ["UPS Next Day Air", "UPS 2nd Day Air", "3 Day Select"];

// Check if orderId is passed in the URL
$orderId = isset($_GET['orderId']) ? $_GET['orderId'] : null;

if ($orderId) {
    // If orderId is passed in the URL, process the order manually
    handleOrder($orderId);
} else {
    // Otherwise, process the order from the webhook data
    $input = file_get_contents('php://input');
    $webhookData = json_decode($input);

    // Check if webhook data is valid
    if (!isset($webhookData->id)) {
        echo 'Invalid webhook data: No order ID found';
        die();
    }

    $orderId = $webhookData->id; // Extract order ID from the webhook payload
    handleOrder($orderId); // Call handleOrder with the orderId
}

// Function to handle order (we will manually call this with the orderId)
function handleOrder($orderId) {
    // Use Shopify API to get order data using your custom function
    $url = SHOPIFY_STORE_URL . "/orders/$orderId.json";  // Just the endpoint path
    $orderData = getShopifyDetails($url);  // Fetch order data using the custom function

    if (!$orderData) {
        echo "Failed to fetch order data for order ID: $orderId";
        return;
    }

    // Get the shipping method from the order data (partial match to handle extra text)
    $shippingMethod = isset($orderData->order->shipping_lines[0]->title) ? $orderData->order->shipping_lines[0]->title : '';

    // Check if the shipping method contains one of the expedited methods (partial matching)
    global $expeditedMethods;
    foreach ($expeditedMethods as $method) {
        if (stripos($shippingMethod, $method) !== false) {
            // Add the "Expedited" tag to the order if a match is found
            applyExpeditedTag($orderId);
            break;  // No need to check further if one match is found
        }
    }
}

// Function to update the order with an "Expedited" tag
function applyExpeditedTag($orderId) {
    $url = SHOPIFY_STORE_URL . "/orders/$orderId.json";  // API endpoint for order

    // Get the current order data using the custom function
    $orderData = getShopifyDetails($url);

    if (!$orderData) {
        echo "Failed to fetch order data for order ID: $orderId";
        return;
    }

    // Add the "Expedited" tag to the order if not already set
    $tags = is_array($orderData->order->tags) ? $orderData->order->tags : (empty($orderData->order->tags) ? [] : [$orderData->order->tags]);
    if (!in_array('Expedited', $tags)) {
        $tags[] = 'Expedited';
    }

    // Prepare the data for updating the order tags
    $updateData = [
        'order' => [
            'id' => $orderId,
            'tags' => array_unique($tags) // Ensure no duplicate tags
        ]
    ];

    // Use your custom update function to update the order tags
    $response = updateShopifyDetails(SHOPIFY_STORE_URL . "/orders/", $updateData, $orderId);

    // Log the success or failure of applying the expedited tag
    if (isset($response->errors)) {
        echo "Failed to apply expedited tag to order ID: $orderId. Error: " . json_encode($response->errors);
    } else {
        echo "Successfully applied expedited tag to order ID: $orderId";
    }
}

http_response_code(200); // Respond that the script has finished processing

?>
