<?php
header("Access-Control-Allow-Origin: *");
ini_set('display_errors', 1);
require 'vendor/autoload.php';
require_once("../engine_all_config_new.php"); 
require_once("../engine_shopify_functions.php");   
use GuzzleHttp\Client;
   // echo '<pre>';
  // print_r($_REQUEST);
  // print_r($_FILES);
   // exit;
if (empty($_REQUEST)) {
    echo "No Data Found.";
} else {
$graphql = <<<'GRAPHQL'
mutation fileCreate($files: [FileCreateInput!]!) {
  fileCreate(files: $files) {
    files {
      id
      alt
      createdAt
    }
    userErrors {
      field
      message
    }
  }
}
GRAPHQL;

function executeGraphQL($query, $variables = []) {
    $client = new Client();
    $graphqlurl = SHOPIFY_STORE_URL.'graphql.json';
    $response = $client->post($graphqlurl, [
        'headers' => [
            'Content-Type' => 'application/json',
            'X-Shopify-Access-Token' => ACCESS_TOKEN,
        ],
        'body' => json_encode([
            'query' => $query,
            'variables' => $variables,
        ]),
    ]);

    return json_decode($response->getBody()->getContents(), true);
}
    
$file_url = array();
$order_details = array();
$file_message='';
if(isset($_FILES['fileimage']['name'])) {
foreach($_FILES['fileimage']['name'] as $key => $pdfName) 
{
    $pdfName = str_replace(' ','-',$pdfName);
    $move = "docs/".$pdfName;
    $tmp_name = $_FILES['fileimage']['tmp_name'][$key];
    $success = move_uploaded_file($tmp_name, $move);
    if($success == 1) {
    
        $fileUrl = FILEPATH.$move;  // URL of the file to upload
        $variables = [
            'files' => [
                [
                    'originalSource' => $fileUrl,
                    'alt' => 'Your PDF description',
                    'contentType' => 'FILE',
                ],
            ],
        ];
        
        $response = executeGraphQL($graphql, $variables);
        /*echo '<pre>';
        print_r($response);
        echo '</pre>';*/
        if (isset($response['data']['fileCreate']['files'][0]['id'])) {
           // echo '<br>File uploaded successfully. File ID: ' . $response['data']['fileCreate']['files'][0]['id'];
                            $graphql1 = <<<'GRAPHQL'
                            query getRecentFiles($first: Int!) {
                              files(first: $first, sortKey: CREATED_AT, reverse: true) {
                                edges {
                                  node {
                                    id
                                    alt
                                    createdAt
                                    ... on GenericFile {
                                      url
                                    }
                                    ... on MediaImage {
                                      image {
                                        originalSrc
                                      }
                                    }
                                  }
                                }
                              }
                            }
GRAPHQL;
                            $variables = [
                                'first' => 5,
                            ];
                            sleep(5);
                            $fileId = $response['data']['fileCreate']['files'][0]['id'];
                            $get_response = executeGraphQL($graphql1, $variables);
                            /*echo '<pre>';
                            print_r($get_response);
                            echo '</pre>';*/
                            $uploaded_url='';
                            if(isset($get_response['data']['files']['edges']) && (count($get_response['data']['files']['edges'])>0)){
                                foreach($get_response['data']['files']['edges'] as $node_key => $data_node){
                                    /*echo 'dddd<pre>';
                                    print_r($data_node);*/
                                    if($data_node['node']['id'] == $fileId){
                                        $uploaded_url = $data_node['node']['url'];
                                        $file_url[] = $uploaded_url;
                                    }
                                }
                            }

        } else {
             $file_message = 'Failed to upload file: ' . json_encode($response['errors']).'<br>';
        }
    }
    
    else {
         $file_message = "File not uploaded<br>";
    }
}// end of foreach
} // end of isset
	if ($_REQUEST['customerName'] == trim($_REQUEST['customerName']) && strpos($_REQUEST['customerName'], ' ')) { 
		$full_name = explode(" ",$_REQUEST['customerName']);
	}
	else{
		$full_name = $_REQUEST['customerName'];
	}
    $order_details = array();
    $meta_counter = 0;
    
    $order_details['draft_order']['id'] = $_REQUEST['draft_order_id'];
    foreach($_REQUEST['line_item'] as $line_key => $line_details){
        foreach($line_details as $keytype => $line_data) {
            $order_details['draft_order']['line_items'][$line_key][$keytype] = $line_data;
        }
    }
   
    $order_details['draft_order']['note'] = $_REQUEST['customerNotes'];
    $order_details['draft_order']['email'] = $_REQUEST['customerEmail'];
	if ($_REQUEST['customerName'] == trim($_REQUEST['customerName']) && strpos($_REQUEST['customerName'], ' ')) {
		$order_details['draft_order']['shipping_address']['first_name'] = $full_name[0];
		$order_details['draft_order']['shipping_address']['last_name'] = $full_name[1];
	}else{
		$order_details['draft_order']['shipping_address']['first_name'] = $full_name;
	}
	$order_details['draft_order']['shipping_address']['phone'] = $_REQUEST['customerPhoneNumber'];
	$order_details['draft_order']['shipping_address']['zip'] = $_REQUEST['customerZipcode'];
	$order_details['draft_order']['shipping_address']['country'] = $_REQUEST['customerCountry'];
    if($_REQUEST['tags']!='' && $_REQUEST['salesperson']!=''){
	    $order_details['draft_order']['tags'] =  $_REQUEST['tags'].','. $_REQUEST['salesperson'];
	}elseif($_REQUEST['tags']!=''){
	    $order_details['draft_order']['tags'] =  $_REQUEST['tags'];
	}elseif($_REQUEST['salesperson']!=''){
	    $order_details['draft_order']['tags'] =  $_REQUEST['salesperson'];
	}
	$i = 0;
	$header_info = 0;
	$page_url =  SHOPIFY_STORE_URL.'draft_orders/'.$_REQUEST['draft_order_id'].'/metafields.json';  
    $draft_meta_response = getShopifyDetails($page_url,$header_info);
        //echo '<br>'.count($draft_meta_response->metafields);

         if(count($draft_meta_response->metafields) > 0){
            $i = 0;
			 $existing_keys = []; // To track existing metafields keys
            foreach($draft_meta_response->metafields as $metakey => $meta_details){
				 $existing_keys[] = $meta_details->key; // Add the key to existing keys array
				if($meta_details->key == 'userfiles') {
                    //$i = count($draft_meta_response->metafields) - 1 ;
					$order_details['draft_order']['metafields'][$i]['id'] = $meta_details->id;
                    $order_details['draft_order']['metafields'][$i]['key'] = 'userfiles';
    	            $order_details['draft_order']['metafields'][$i]['namespace'] = 'custom';
    	            $order_details['draft_order']['metafields'][$i]['type'] = 'multi_line_text_field';
    	            $order_details['draft_order']['metafields'][$i]['value'] = isset($file_url) && (count($file_url)>0)?implode(',',$file_url):$meta_details->value;//implode(',',$file_url);// $meta_details->value.",". implode(',',$file_url);
                }
                elseif($meta_details->key == 'days'){
                    //$i = count($draft_meta_response->metafields) - 1 ;
                    $order_details['draft_order']['metafields'][$i]['id'] = $meta_details->id;
                    $order_details['draft_order']['metafields'][$i]['key'] = 'days';
    	            $order_details['draft_order']['metafields'][$i]['namespace'] = 'custom';
    	            $order_details['draft_order']['metafields'][$i]['type'] = 'date';
    	            $order_details['draft_order']['metafields'][$i]['value'] = isset($_REQUEST['days']) && $_REQUEST['days']!=''?$_REQUEST['days']:$meta_details->value;
                }
				elseif($meta_details->key == 'calculation'){
                    //$i = count($draft_meta_response->metafields) - 1 ;
                    $order_details['draft_order']['metafields'][$i]['id'] = $meta_details->id;
                    $order_details['draft_order']['metafields'][$i]['key'] = 'calculation';
    	            $order_details['draft_order']['metafields'][$i]['namespace'] = 'custom';
    	            $order_details['draft_order']['metafields'][$i]['type'] = 'boolean';
    	            $order_details['draft_order']['metafields'][$i]['value'] = isset($_REQUEST['calculation']) && $_REQUEST['calculation']!=''?$_REQUEST['calculation']:$meta_details->value;
                }
				elseif($meta_details->key == 'upload_type'){
                    //$i = count($draft_meta_response->metafields) - 1 ;
                    $order_details['draft_order']['metafields'][$i]['id'] = $meta_details->id;
                    $order_details['draft_order']['metafields'][$i]['key'] = 'upload_type';
    	            $order_details['draft_order']['metafields'][$i]['namespace'] = 'custom';
    	            $order_details['draft_order']['metafields'][$i]['type'] = 'single_line_text_field';
    	            $order_details['draft_order']['metafields'][$i]['value'] = isset($_REQUEST['upload_type']) && $_REQUEST['upload_type']!=''?$_REQUEST['upload_type']:$meta_details->value;
                }
                else{
                    $order_details['draft_order']['metafields'][$i]['id'] = $meta_details->id;
                    $order_details['draft_order']['metafields'][$i]['key'] =  $meta_details->key;
    	            $order_details['draft_order']['metafields'][$i]['namespace'] =  $meta_details->namespace;
    	            $order_details['draft_order']['metafields'][$i]['type'] =  $meta_details->type;
    	            $order_details['draft_order']['metafields'][$i]['value'] =  $meta_details->value;
                }
                $i++;
            }
			
			// Check and add new metafields if not already in existing metafields
			if (!in_array('days', $existing_keys) && isset($_REQUEST['days'])) {
				// Add new 'calculation' metafield
				$order_details['draft_order']['metafields'][$i]['key'] = 'days';
				$order_details['draft_order']['metafields'][$i]['namespace'] = 'custom';
				$order_details['draft_order']['metafields'][$i]['type'] = 'date';
				$order_details['draft_order']['metafields'][$i]['value'] = $_REQUEST['days'];
				$i++;
			}
			
			if (!in_array('calculation', $existing_keys) && isset($_REQUEST['calculation'])) {
				// Add new 'calculation' metafield
				$order_details['draft_order']['metafields'][$i]['key'] = 'calculation';
				$order_details['draft_order']['metafields'][$i]['namespace'] = 'custom';
				$order_details['draft_order']['metafields'][$i]['type'] = 'boolean';
				$order_details['draft_order']['metafields'][$i]['value'] = $_REQUEST['calculation'];
				$i++;
			}

			if (!in_array('upload_type', $existing_keys) && isset($_REQUEST['upload_type'])) {
				// Add new 'upload_type' metafield
				$order_details['draft_order']['metafields'][$i]['key'] = 'upload_type';
				$order_details['draft_order']['metafields'][$i]['namespace'] = 'custom';
				$order_details['draft_order']['metafields'][$i]['type'] = 'single_line_text_field';
				$order_details['draft_order']['metafields'][$i]['value'] = $_REQUEST['upload_type'];
				$i++;
			}

			// Add other new metafields like 'userfiles' if necessary
			if (!in_array('userfiles', $existing_keys) && count($file_url) > 0) {
				$order_details['draft_order']['metafields'][$i]['key'] = 'userfiles';
				$order_details['draft_order']['metafields'][$i]['namespace'] = 'custom';
				$order_details['draft_order']['metafields'][$i]['type'] = 'multi_line_text_field';
				$order_details['draft_order']['metafields'][$i]['value'] = implode(',', $file_url);
				$i++;
			}
            
        }else{
           	if(isset($_REQUEST['days']) && $_REQUEST['days']!=''){
            	$order_details['draft_order']['metafields'][$i]['key'] = 'days';
            	$order_details['draft_order']['metafields'][$i]['namespace'] = 'custom';
            	$order_details['draft_order']['metafields'][$i]['type'] = 'date';
            	$order_details['draft_order']['metafields'][$i]['value'] = $_REQUEST['days'];
            	$i++;
        	}
			if(isset($_REQUEST['calculation']) && $_REQUEST['calculation']!=''){
            	$order_details['draft_order']['metafields'][$i]['key'] = 'calculation';
            	$order_details['draft_order']['metafields'][$i]['namespace'] = 'custom';
            	$order_details['draft_order']['metafields'][$i]['type'] = 'boolean';
            	$order_details['draft_order']['metafields'][$i]['value'] = $_REQUEST['calculation'];
            	$i++;
        	}
			if(isset($_REQUEST['upload_type']) && $_REQUEST['upload_type']!=''){
            	$order_details['draft_order']['metafields'][$i]['key'] = 'upload_type';
            	$order_details['draft_order']['metafields'][$i]['namespace'] = 'custom';
            	$order_details['draft_order']['metafields'][$i]['type'] = 'single_line_text_field';
            	$order_details['draft_order']['metafields'][$i]['value'] = $_REQUEST['upload_type'];
            	$i++;
        	}
           	if(count($file_url)>0){
    	        $order_details['draft_order']['metafields'][$i]['key'] = 'userfiles';
        	    $order_details['draft_order']['metafields'][$i]['namespace'] = 'custom';
        	    $order_details['draft_order']['metafields'][$i]['type'] = 'multi_line_text_field';
        	    $order_details['draft_order']['metafields'][$i]['value'] = implode(',',$file_url);
    	  	    $i++;
	        }
        }

    //echo '<pre>';
    //print_r($order_details);
    //exit;
    $update_product_meta_success = updateShopifyDetails(SHOPIFY_STORE_URL."draft_orders/",$order_details,$_REQUEST['draft_order_id']);  
     // echo '<pre>';
     // print_r($update_product_meta_success); 
     // exit;
    if(!isset($update_product_meta_success->errors)) {
      $file_message .= "Draft order updated successfully.";      
	}
    else {
       $file_message .="Error updating draft order.";   
    }
	$data = ["message" => $file_message];
	echo json_encode($data);
    exit;
}
?>