<?php
function get_headers_from_curl_response($response)
{
    $headers = array();
    
    $header_text = substr($response, 0, strpos($response, "\r\n\r\n"));

    foreach (explode("\r\n", $header_text) as $i => $line)
        if ($i === 0)
            $headers['http_code'] = $line;
        else
        {
            list ($key, $value) = explode(': ', $line);

            $headers[$key] = $value;
        }
    return $headers;
}
function getShopifyDetails($url,$header_info=0) {
   
     $session = curl_init();
     curl_setopt($session, CURLOPT_URL, $url);
     curl_setopt($session, CURLOPT_HTTPGET, 1); 
     curl_setopt($session, CURLOPT_HEADER, $header_info);
     curl_setopt($session, CURLOPT_HTTPHEADER, array('Content-Type: application/json','X-Shopify-Access-Token:'.ACCESS_TOKEN));
     curl_setopt($session, CURLOPT_RETURNTRANSFER, true);
     curl_setopt($session,CURLOPT_SSL_VERIFYPEER,false);
     $response = curl_exec($session);
   
	 if($header_info == '1'){    
			$header_size = curl_getinfo($session, CURLINFO_HEADER_SIZE);
			$headers = get_headers_from_curl_response($response); 
			$body = substr($response, $header_size); 
			$response = json_decode($body);   
			if(isset($headers['link'])){
				$response->link = $headers['link'];
			}
           // exit;
	 }
	 else{
		 $response = json_decode($response); 
	 }   
    // echo '<pre>ddd';print_r($response);
    if(curl_errno($session)){
        echo $response = 'Curl error: ' . curl_error($session);
     }
     curl_close($session);
     return $response;
}

function getpageurl($response,$page_url){
	 $p1 = str_replace("<","",$response->link);
	 $p2 = str_replace(">","",$p1); 
	 $p3 = explode('; rel="next"',$p2);
	 $p4 = explode('page_info=',$p3[0]);  
	 if(count($p4) == 3) {
		$page_url = $page_url.'&page_info='.trim($p4[2]);     
	  }
	  else {    
		$page_url = $page_url.'&page_info='.trim($p4[1]);
	  }   
	  return $page_url;
}
function DeleteShopifyProduct($baseUrl,$product_id) {     
    $ch = curl_init($baseUrl."products/$product_id.json"); //set the url
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");  //specify this as a POST
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json','X-Shopify-Access-Token:'.ACCESS_TOKEN));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); //specify return value as string
    $server_output = curl_exec ($ch); //get server output if you wish to error handle / debug
    if(curl_errno($ch)){
        echo $server_output = 'Curl error: ' . curl_error($ch);
    }
    curl_close ($ch); //close the connection
    return $server_output; 
}

function updateShopifyDetails($baseUrl,$data_detail_array,$data_id='') { 
    
    if($data_id!='') {
        $ch = curl_init($baseUrl."$data_id.json"); //set the url
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");  //specify this as a POST
    }
    else {    
        $ch = curl_init($baseUrl); //set the url
    }
    
    $data_string = json_encode($data_detail_array); //encode the product as json
    // echo '<pre>';
    // print_r($data_string);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);                                  
    curl_setopt($ch, CURLOPT_POST, 1);//specify this as a POST
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string); //set the POST string
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); //specify return value as string
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'Content-Type: application/json',
    'X-Shopify-Access-Token:'.ACCESS_TOKEN,
    'Content-Length: ' .strlen($data_string))
    ); //specify that this is a JSON call
    $server_output = curl_exec ($ch); //get server output if you wish to error handle / debug
    // echo '<pre>';
    // print_r($server_output);
    // exit;
    $server_output = json_decode($server_output);
    if(curl_errno($ch)){
        echo $server_output = 'Curl error: ' . curl_error($ch);
     }
    curl_close ($ch); //close the connection
    return $server_output; 
}
function objectToArray ($object) {
        if(!is_object($object) && !is_array($object))
            return $object;

        return array_map('objectToArray', (array) $object);
}
function waitforshopifycall($shopify_counter) {
     if($shopify_counter % 2 == 0) {
          sleep(1);
     }                             
}  
function object_to_array($data)
{
    if (is_array($data) || is_object($data))
    {
        $result = array();
        foreach ($data as $key => $value)
        {
            $result[$key] = object_to_array($value);
        }
        return $result;
    }
    return $data;
} 

function updateShopifyInventoryDetails($baseUrl,$product_detail_array,$product_id,$variant_id='') { 
    if($variant_id !='') {
        $ch = curl_init($baseUrl."inventory_levels/set.json"); //set the url
        $data_string = json_encode($product_detail_array); //encode the product as json
        curl_setopt($ch, CURLOPT_POST, 1);
    }
    else {  
        $ch = curl_init($baseUrl."products/$product_id.json"); //set the url
        $data_string = json_encode(array('product'=>$product_detail_array)); //encode the product as json
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT"); 
    }
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
     //specify this as a POST
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string); //set the POST string
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); //specify return value as string
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
    'Content-Type: application/json',
    'X-Shopify-Access-Token:'.ACCESS_TOKEN,
    'Content-Length: ' . strlen($data_string)
    )); //specify that this is a JSON call
    $server_output = curl_exec ($ch); //get server output if you wish to error handle / debug
    echo curl_error($ch);
    curl_close ($ch); //close the connection
    return $server_output; 
}     
?>